# Defines
#  LIBSQUISH_FOUND
#  LIBSQUISH_INCLUDE_DIR
#  LIBSQUISH_LIBRARIES

FIND_PATH(LIBSQUISH_INCLUDE_DIR squish.h PATHS . squish .. ../squish DOC "Directory containing libSquish headers")
FIND_LIBRARY(LIBSQUISH_LIBRARY NAMES squish libsquish PATHS . squish .. ../squish PATH_SUFFIXES lib lib64 release minsizerel relwithdebinfo DOC "Path to libSquish library")

SET(LIBSQUISH_LIBRARIES ${LIBSQUISH_LIBRARY})

IF (LIBSQUISH_LIBRARY AND LIBSQUISH_INCLUDE_DIR)
   SET(LIBSQUISH_FOUND TRUE)
   MESSAGE(STATUS "Found libSquish: ${LIBSQUISH_LIBRARY}")
ELSE (LIBSQUISH_LIBRARY AND LIBSQUISH_INCLUDE_DIR)
   MESSAGE(STATUS "Could not find libSquish")
ENDIF (LIBSQUISH_LIBRARY AND LIBSQUISH_INCLUDE_DIR)
