/* -*- coding: utf-8 -*- */
/* -*- mode: c -*- */
/*
 * Dislocker -- enables to read/write on BitLocker encrypted partitions under
 * Linux
 * Copyright (C) 2012-2013  Romain Coltel, Hervé Schauer Consultants
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
 */
#ifndef DIS_RUBY_H
#define DIS_RUBY_H

#ifdef _HAVE_RUBY
#include <stdarg.h>

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunknown-pragmas"
#pragma clang diagnostic ignored "-Wunknown-attributes"
#endif /* defined(__clang__) */

#include <ruby.h>

#if defined(__clang__)
#pragma clang diagnostic pop
#endif /* defined(__clang__) */

#ifndef rb_str_vcatf
#define rb_str_vcatf dis_rb_str_vcatf
VALUE rb_str_vcatf(VALUE str, const char *fmt, va_list ap);
#endif

#ifndef rb_str_catf
#define rb_str_catf dis_rb_str_catf
VALUE rb_str_catf(VALUE str, const char *fmt, ...);
#endif

#endif /* _HAVE_RUBY */

#endif /* DIS_RUBY_H */
