/*
 * Copyright (c) 2007 - 2023 by mod_tile contributors (see AUTHORS file)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; If not, see http://www.gnu.org/licenses/.
 */

#ifndef GEN_TILE_H
#define GEN_TILE_H

#include "protocol.h"

#ifdef __cplusplus
extern "C" {
#endif

enum queueEnum { queueRequest,
		 queueRequestPrio,
		 queueRequestBulk,
		 queueDirty,
		 queueRender,
		 queueDuplicate,
		 queueRequestLow
	       };

struct item {
	struct item *next;
	struct item *prev;
	struct protocol req;
	int mx, my;
	int fd;
	struct item *duplicates;
	enum queueEnum inQueue;
	enum queueEnum originatedQueue;
};

// int render(Map &m, int x, int y, int z, const char *filename);
void *render_thread(void *);
struct item *fetch_request(void);
void delete_request(struct item *item);
void render_init(const char *plugins_dir, const char *font_dir, int font_recurse);

#ifdef __cplusplus
}
#endif

#endif
